import java.net.URL;
import org.apache.axis.client.Service;
import org.apache.axis.client.Call;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.AxisFault;
import javax.xml.rpc.ParameterMode;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.*;
import org.apache.axis.encoding.ser.*;

public class SendToNumber {

    public static void main(String [] args) throws Exception {

	SendToNumber stn = new SendToNumber();

	//grab input arguments
	String msisdn = args[0];
	String body   = args[1];

	//validate input arguments
	if (msisdn.length() == 0 || body.length() == 0) {
	    System.out.println("Usage: send_to_number msisdn body");
	    System.exit(1);
	}

	// Enter your account information below
	String username = "replace_with_your_username";
	String password = "replace_with_your_password";
	// Enter your short code below
	String originator = "replace_with_your_originator";

	try {
	    String endpointURL = "http://soap.ewingz.com/SOAP";
	    String sURI = "http://soap.ewingz.com/eWingz/SOAP/QC40/";
	    System.out.println("Creating SOAP object...");

	    //set up SOAP object
	    Service service = new Service();
	    Call call = (Call) service.createCall();
	    call.setTargetEndpointAddress( new java.net.URL(endpointURL) );
	    call.setOperationName(new QName(sURI,"send_to_number"));
	    call.setUseSOAPAction(true);
	    call.setSOAPActionURI(sURI + "#send_to_number");
	    call.setOperationStyle("rpc");

	    //set parameter types
	    stn.AddParameters(call);

	    //set return type
	    call.setReturnType(new QName(sURI + "qc40/type",
					 "send_to_number_result"),
			       SendToNumberResultBean.class);

	    //declare Type Mappings
	    stn.AddTypeMappings(call);
	    System.out.println("Calling send_to_number...");

	    try {
		//call send_to_number method
		SendToNumberResultBean stnrb
		    = (SendToNumberResultBean)
		    call.invoke(
				new Object[] {
				    username,
				    password,
				    new Boolean(false),
				    "handset",
				    "GSM0338",
				    new	Integer(1),
				    new Boolean(false),
				    Base64.encode(new String(originator).
						  getBytes()),
				    "",
				    Base64.encode(new String(body).getBytes()),
				    "",
				    msisdn,
				    "",
				    new Boolean(false),
				    ""
				} );

		//request succeeded
		System.out.println("Request succeeded.");
		System.out.println("\nResponse:");

		//print send_to_number_result data to stdout
		System.out.println("\tuniqueid = " +
				   new String(stnrb.getUniqueid()));
		System.out.println("\tsegments = " + stnrb.getSegments());
		System.out.println("\tresponse_code = " +
				   stnrb.getResponse_code());
		System.out.println("\tresponse_text = " +
				   stnrb.getResponse_text());
		System.out.println("\tdisposition_code = " +
				   stnrb.getDisposition_code());
		System.out.println("\tdisposition_text = " +
				   stnrb.getDisposition_text());
	    } catch (Exception e) {
		//create fault object
		AxisFault fault = AxisFault.makeFault(e);
		QName qn = fault.getFaultCode();

		//request failed
		System.out.println("Request failed.");
		System.out.println("\nResponse:");

		//print fault information to stdout
		System.out.println("\tFault string: " + fault.getFaultString());
		System.out.println("\tFault code: " + qn.toString());
	    }
	} catch (Exception e) {
	    // Main Exception
	    System.err.println(e.toString());
	}
    }

    /**
     * @param call
     */
    private void AddParameters(Call call) {
	//username
	call.addParameter("username",
			  org.apache.axis.Constants.XSD_STRING,
			  javax.xml.rpc.ParameterMode.IN);
	//password
	call.addParameter("password",
			  org.apache.axis.Constants.XSD_STRING,
			  javax.xml.rpc.ParameterMode.IN);
	//testmode
	call.addParameter("testmode",
			  org.apache.axis.Constants.XSD_BOOLEAN,
			  javax.xml.rpc.ParameterMode.IN);
	//notification
	call.addParameter("notification",
			  org.apache.axis.Constants.XSD_STRING,
			  javax.xml.rpc.ParameterMode.IN);
	//type
	call.addParameter("type",
			  org.apache.axis.Constants.XSD_STRING,
			  javax.xml.rpc.ParameterMode.IN);
	//class
	call.addParameter("class",
			  org.apache.axis.Constants.XSD_INTEGER,
			  javax.xml.rpc.ParameterMode.IN);
	//udhi
	call.addParameter("udhi",
			  org.apache.axis.Constants.XSD_BOOLEAN,
			  javax.xml.rpc.ParameterMode.IN);
	//originator
	call.addParameter("originator",
			  org.apache.axis.Constants.XSD_BASE64,
			  javax.xml.rpc.ParameterMode.IN);
	//header
	call.addParameter("header",
			  org.apache.axis.Constants.XSD_BASE64,
			  javax.xml.rpc.ParameterMode.IN);
	//body
	call.addParameter("body",
			  org.apache.axis.Constants.XSD_BASE64,
			  javax.xml.rpc.ParameterMode.IN);
	//footer
	call.addParameter("footer",
			  org.apache.axis.Constants.XSD_BASE64,
			  javax.xml.rpc.ParameterMode.IN);
	//msisdn
	call.addParameter("msisdn",
			  org.apache.axis.Constants.XSD_STRING,
			  javax.xml.rpc.ParameterMode.IN);
	//uniqueid
	call.addParameter("uniqueid",
			  org.apache.axis.Constants.XSD_BASE64,
			  javax.xml.rpc.ParameterMode.IN);
	//set_reply_path
	call.addParameter("set_reply_path",
			  org.apache.axis.Constants.XSD_BOOLEAN,
			  javax.xml.rpc.ParameterMode.IN);
	//deliver_after
	call.addParameter("deliver_after",
			  org.apache.axis.Constants.XSD_DATE,
			  javax.xml.rpc.ParameterMode.IN);
    }

    /**
     * @param call
     */

    private void AddTypeMappings(Call call) {
	//declare serializer for SOAPStruct (contains send_to_number_result)
	call.registerTypeMapping(SendToNumberResultBean.class,
				 new QName(
					   "http://xml.apache.org/xml-soap",
					   "SOAPStruct"),
				 BeanSerializerFactory.class,
				 BeanDeserializerFactory.class);

	//declare serializer for Base64
	call.registerTypeMapping(Base64.class,
				 new QName("http://xml.apache.org/xml-soap",
					   "Base64"),
				 Base64SerializerFactory.class,
				 Base64DeserializerFactory.class);
    }

}
